/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.lwjgl;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.List;

public class LwjglClipboard
implements com.badlogic.gdx.utils.Clipboard,
ClipboardOwner {
    public String getContents() {
        try {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable contents = clipboard.getContents(null);
            if (contents != null) {
                if (contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    try {
                        return (String)contents.getTransferData(DataFlavor.stringFlavor);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (contents.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    try {
                        List files = (List)contents.getTransferData(DataFlavor.javaFileListFlavor);
                        StringBuilder buffer = new StringBuilder(128);
                        int n = files.size();
                        for (int i = 0; i < n; ++i) {
                            if (buffer.length() > 0) {
                                buffer.append('\n');
                            }
                            buffer.append(((File)files.get(i)).toString());
                        }
                        return buffer.toString();
                    }
                    catch (RuntimeException runtimeException) {}
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public void setContents(String content) {
        try {
            StringSelection stringSelection = new StringSelection(content);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void lostOwnership(Clipboard arg0, Transferable arg1) {
    }
}

